import numpy as np

class Experiment:

    def __init__(self, experiment_id, rho):
        self.experiment_id = experiment_id

        if self.experiment_id == 1:
            self.k = 2
            self.mean = np.array([1.0, 0.99])
            self.variance = np.ones(self.k)
            self.rho = rho
            self.cov = np.array([
            [1.0, self.rho],
            [self.rho, 1.0]
        ])

        if self.experiment_id == 2:
            self.k = 3
            self.mean = np.array([2.0, 1.8, 1.8])
            self.variance = np.array([1.0, 1.0, 1.0])
            self.rho = rho
            self.cov = np.array([
            [1.0, self.rho*np.sqrt(self.variance[0]*self.variance[1]), self.rho*np.sqrt(self.variance[0]*self.variance[2])],
            [self.rho*np.sqrt(self.variance[1]*self.variance[0]) , 1.0, self.rho*np.sqrt(self.variance[1]*self.variance[2])],
            [self.rho*np.sqrt(self.variance[2]*self.variance[0]), self.rho*np.sqrt(self.variance[2]*self.variance[1]), 1.0]
        ])








